using System;
using System.Data;
using System.Windows.Forms;
using ANTISERAWORKLISTTYPING = gov.va.med.vbecs.Common.VbecsTables.AntiseraWorklistTyping;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.GUI
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Cameron Taylor</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>8/13/2003</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	/// Antisera Worklist selection/definition screen
	///</summary>

	#endregion

	public class DlgSelectSpecificities : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Variables
		//
		private DataTable _antiseraWorklists;
		private DataTable _antiseraWorklistTypings;
		//
		private DataTable _dtRacks;
		private DataTable _dtTests;
		private DataTable _dtReagents;
		private DataTable _dtSpecificities;
		private DataTable _dtUnits;
		private DataRow _drAntigenTyping;
		private Guid _antiDControlGuid = Guid.Empty;
		private string _antiDControlComment = null;
		//
		private BOL.RackLot _rackLot;
		private BOL.AntiseraWorklist _antiseraWorklist;
		//
		private bool _isLoading;
		/// <summary>
		/// current date value based on the division time zone
		/// </summary>
		private System.DateTime _currentDate;

		#endregion

		#region Form Controls
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		private System.Windows.Forms.ColumnHeader columnHeader4;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox picImage;
		private System.Windows.Forms.GroupBox grpAntisera;
		private System.Windows.Forms.TextBox txtExpirationDate;
		private System.Windows.Forms.Label lblExpirationDate;
		private System.Windows.Forms.TextBox txtManufacturer;
		private System.Windows.Forms.Label lblManufacturer;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbRack;
		private System.Windows.Forms.Label lblRack;
		private System.Windows.Forms.RadioButton rdoISRT;
		private System.Windows.Forms.RadioButton rdoIS;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbLotNumber;
		private System.Windows.Forms.Label lblLotNumber;
		private System.Windows.Forms.RadioButton rdoIS37;
		private System.Windows.Forms.ListView lvAntisera;
		private System.Windows.Forms.RadioButton rdoAHGCC;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnAdd;
		private System.Windows.Forms.Button btnClear;
		private System.Windows.Forms.Panel pnlNewAntisera;
		private System.Windows.Forms.Panel pnlPartialComplete;
		private System.Windows.Forms.ColumnHeader columnHeader5;
		private System.Windows.Forms.GroupBox grpTestingPhases;
		private System.Windows.Forms.ColumnHeader columnHeader14;
		private System.Windows.Forms.ColumnHeader columnHeader15;
		private System.Windows.Forms.ColumnHeader columnHeader8;
		private System.Windows.Forms.ColumnHeader columnHeader9;
		private System.Windows.Forms.GroupBox grpPartialWorklists;
		private System.Windows.Forms.GroupBox grpSelectedSpecificities;
		private System.Windows.Forms.ListView lvPartialWorklists;
		private System.Windows.Forms.CheckBox cbNewWorklist;
		private System.Windows.Forms.CheckBox cbPartialWorklist;
		private System.Windows.Forms.TabControl tabControl1;
		private System.Windows.Forms.TabPage pageSpecificities;
		private System.Windows.Forms.Button btnDelete;
		private System.Windows.Forms.TabPage pageUnits;
		private System.Windows.Forms.ListView lvSelectedUnits;
		private System.Windows.Forms.ColumnHeader columnHeader11;
		private System.Windows.Forms.ColumnHeader columnHeader12;
		private System.Windows.Forms.ColumnHeader columnHeader13;
		private System.Windows.Forms.ColumnHeader columnHeader16;
		private System.Windows.Forms.ListView lvSpecificities;
		private System.Windows.Forms.ColumnHeader columnHeader10;
		private System.Windows.Forms.ColumnHeader columnHeader17;
		private System.Windows.Forms.ColumnHeader columnHeader18;
		private System.Windows.Forms.ColumnHeader columnHeader19;
		private System.Windows.Forms.ColumnHeader columnHeader20;
		private System.Windows.Forms.ColumnHeader columnHeader21;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbAntigenTyping;
		private System.Windows.Forms.Label lblAntigenTyping;
		private System.Windows.Forms.TextBox txtAntigen;
		private System.Windows.Forms.Label lblAntigen;
		private System.Windows.Forms.Label lblTestedBy;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbTestedBy;
		private System.Windows.Forms.DateTimePicker dtpDateTested;
		private System.Windows.Forms.Label lblDateTested;
		private System.Windows.Forms.RadioButton rdo37AHGCC;
		private System.Windows.Forms.ColumnHeader columnHeader6;
		private System.Windows.Forms.ColumnHeader columnHeader7;
		private System.Windows.Forms.RadioButton rdoSolidPhase;
		private System.Windows.Forms.RadioButton rdoGel;
		private System.Windows.Forms.RadioButton rdoTube;
		private System.Windows.Forms.GroupBox grpAutomatedInstrument;
		private System.Windows.Forms.CheckBox cbInstrumentQCd;
		private System.Windows.Forms.TextBox txtInstrumentName;
		private System.Windows.Forms.Label lblInstrumentName;
		private System.Windows.Forms.CheckBox cbAutomatedInstrument;
		private System.Windows.Forms.ColumnHeader columnHeader23;
		private System.Windows.Forms.ColumnHeader columnHeader24;
		private System.Windows.Forms.GroupBox grpTestingDetails;
		private System.Windows.Forms.GroupBox grpTestingMethod;
		private System.ComponentModel.IContainer components = null;

		#endregion

		#region Constructors/Dispose
		/// <summary>
		/// Select Specificities dialog constructor
		/// </summary>
		public DlgSelectSpecificities()
		{
			this.LockController.LockFunction = Common.LockFunctions.UC041RecordPhenotypeResults;

			// This call is required by the Windows Form Designer.
			this._isLoading = true;
			//
			InitializeComponent();
			this.SetComponentProperties();
			this.InitializeWorklist();
			//
			this._isLoading = false;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		//CR 3115 Removed Leave event from cmbLotNumber
		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgSelectSpecificities));
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.picImage = new System.Windows.Forms.PictureBox();
			this.grpAntisera = new System.Windows.Forms.GroupBox();
			this.btnClear = new System.Windows.Forms.Button();
			this.cmbAntigenTyping = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.btnAdd = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.cmbLotNumber = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblLotNumber = new System.Windows.Forms.Label();
			this.lblAntigenTyping = new System.Windows.Forms.Label();
			this.txtExpirationDate = new System.Windows.Forms.TextBox();
			this.lblExpirationDate = new System.Windows.Forms.Label();
			this.txtManufacturer = new System.Windows.Forms.TextBox();
			this.lblManufacturer = new System.Windows.Forms.Label();
			this.grpTestingPhases = new System.Windows.Forms.GroupBox();
			this.rdo37AHGCC = new System.Windows.Forms.RadioButton();
			this.rdoIS = new System.Windows.Forms.RadioButton();
			this.rdoISRT = new System.Windows.Forms.RadioButton();
			this.rdoIS37 = new System.Windows.Forms.RadioButton();
			this.rdoAHGCC = new System.Windows.Forms.RadioButton();
			this.lblAntigen = new System.Windows.Forms.Label();
			this.txtAntigen = new System.Windows.Forms.TextBox();
			this.cmbRack = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblRack = new System.Windows.Forms.Label();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.lvAntisera = new System.Windows.Forms.ListView();
			this.columnHeader1 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader2 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader7 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader3 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader14 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader15 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader4 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader5 = new System.Windows.Forms.ColumnHeader();
			this.pnlNewAntisera = new System.Windows.Forms.Panel();
			this.grpSelectedSpecificities = new System.Windows.Forms.GroupBox();
			this.cbPartialWorklist = new System.Windows.Forms.CheckBox();
			this.grpAutomatedInstrument = new System.Windows.Forms.GroupBox();
			this.cbAutomatedInstrument = new System.Windows.Forms.CheckBox();
			this.cbInstrumentQCd = new System.Windows.Forms.CheckBox();
			this.txtInstrumentName = new System.Windows.Forms.TextBox();
			this.lblInstrumentName = new System.Windows.Forms.Label();
			this.grpTestingMethod = new System.Windows.Forms.GroupBox();
			this.rdoTube = new System.Windows.Forms.RadioButton();
			this.rdoGel = new System.Windows.Forms.RadioButton();
			this.rdoSolidPhase = new System.Windows.Forms.RadioButton();
			this.lblTestedBy = new System.Windows.Forms.Label();
			this.cmbTestedBy = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.dtpDateTested = new System.Windows.Forms.DateTimePicker();
			this.lblDateTested = new System.Windows.Forms.Label();
			this.pnlPartialComplete = new System.Windows.Forms.Panel();
			this.cbNewWorklist = new System.Windows.Forms.CheckBox();
			this.grpPartialWorklists = new System.Windows.Forms.GroupBox();
			this.tabControl1 = new System.Windows.Forms.TabControl();
			this.pageSpecificities = new System.Windows.Forms.TabPage();
			this.lvSpecificities = new System.Windows.Forms.ListView();
			this.columnHeader6 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader10 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader17 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader21 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader20 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader18 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader19 = new System.Windows.Forms.ColumnHeader();
			this.pageUnits = new System.Windows.Forms.TabPage();
			this.lvSelectedUnits = new System.Windows.Forms.ListView();
			this.columnHeader11 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader12 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader13 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader16 = new System.Windows.Forms.ColumnHeader();
			this.lvPartialWorklists = new System.Windows.Forms.ListView();
			this.columnHeader8 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader9 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader23 = new System.Windows.Forms.ColumnHeader();
			this.columnHeader24 = new System.Windows.Forms.ColumnHeader();
			this.btnDelete = new System.Windows.Forms.Button();
			this.grpTestingDetails = new System.Windows.Forms.GroupBox();
			this.grpImage.SuspendLayout();
			this.grpAntisera.SuspendLayout();
			this.grpTestingPhases.SuspendLayout();
			this.pnlNewAntisera.SuspendLayout();
			this.grpSelectedSpecificities.SuspendLayout();
			this.grpAutomatedInstrument.SuspendLayout();
			this.grpTestingMethod.SuspendLayout();
			this.pnlPartialComplete.SuspendLayout();
			this.grpPartialWorklists.SuspendLayout();
			this.tabControl1.SuspendLayout();
			this.pageSpecificities.SuspendLayout();
			this.pageUnits.SuspendLayout();
			this.grpTestingDetails.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(532, 30);
			this.vbecsLogo1.TabIndex = 5;
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 7;
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.picImage);
			this.grpImage.Location = new System.Drawing.Point(4, 28);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 400);
			this.grpImage.TabIndex = 6;
			this.grpImage.TabStop = false;
			// 
			// picImage
			// 
			this.picImage.Image = ((System.Drawing.Image)(resources.GetObject("picImage.Image")));
			this.picImage.Location = new System.Drawing.Point(4, 12);
			this.picImage.Name = "picImage";
			this.picImage.Size = new System.Drawing.Size(45, 45);
			this.picImage.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picImage.TabIndex = 0;
			this.picImage.TabStop = false;
			// 
			// grpAntisera
			// 
			this.grpAntisera.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpAntisera.Controls.Add(this.btnClear);
			this.grpAntisera.Controls.Add(this.cmbAntigenTyping);
			this.grpAntisera.Controls.Add(this.btnAdd);
			this.grpAntisera.Controls.Add(this.cmbLotNumber);
			this.grpAntisera.Controls.Add(this.lblLotNumber);
			this.grpAntisera.Controls.Add(this.lblAntigenTyping);
			this.grpAntisera.Controls.Add(this.txtExpirationDate);
			this.grpAntisera.Controls.Add(this.lblExpirationDate);
			this.grpAntisera.Controls.Add(this.txtManufacturer);
			this.grpAntisera.Controls.Add(this.lblManufacturer);
			this.grpAntisera.Controls.Add(this.grpTestingPhases);
			this.grpAntisera.Controls.Add(this.lblAntigen);
			this.grpAntisera.Controls.Add(this.txtAntigen);
			this.grpAntisera.Controls.Add(this.cmbRack);
			this.grpAntisera.Controls.Add(this.lblRack);
			this.grpAntisera.Location = new System.Drawing.Point(0, 80);
			this.grpAntisera.Name = "grpAntisera";
			this.grpAntisera.Size = new System.Drawing.Size(468, 168);
			this.grpAntisera.TabIndex = 2;
			this.grpAntisera.TabStop = false;
			this.grpAntisera.Text = "Define Antiserum Specificity";
			// 
			// btnClear
			// 
			this.btnClear.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnClear.Location = new System.Drawing.Point(384, 140);
			this.btnClear.Name = "btnClear";
			this.btnClear.TabIndex = 14;
			this.btnClear.Text = "C&lear";
			this.btnClear.Click += new System.EventHandler(this.btnClear_Click);
			this.btnClear.MouseHover += new System.EventHandler(this.btnClear_MouseHover);
			// 
			// cmbAntigenTyping
			// 
			this.cmbAntigenTyping.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbAntigenTyping.Interval = 500;
			this.cmbAntigenTyping.Location = new System.Drawing.Point(92, 20);
			this.cmbAntigenTyping.MaxLength = 25;
			this.cmbAntigenTyping.Name = "cmbAntigenTyping";
			this.cmbAntigenTyping.Size = new System.Drawing.Size(192, 22);
			this.cmbAntigenTyping.TabIndex = 1;
			this.cmbAntigenTyping.SelectedIndexChanged += new System.EventHandler(this.cmbAntigenTyping_SelectedIndexChanged);
			// 
			// btnAdd
			// 
			this.btnAdd.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnAdd.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnAdd.Image = ((System.Drawing.Image)(resources.GetObject("btnAdd.Image")));
			this.btnAdd.Location = new System.Drawing.Point(304, 140);
			this.btnAdd.Name = "btnAdd";
			this.btnAdd.Size = new System.Drawing.Size(75, 23);
			this.btnAdd.TabIndex = 13;
			this.btnAdd.Click += new System.EventHandler(this.btnAdd_Click);
			this.btnAdd.MouseHover += new System.EventHandler(this.btnAdd_MouseHover);
			// 
			// cmbLotNumber
			// 
			this.cmbLotNumber.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbLotNumber.Enabled = false;
			this.cmbLotNumber.Interval = 500;
			this.cmbLotNumber.Location = new System.Drawing.Point(92, 44);
			this.cmbLotNumber.MaxLength = 15;
			this.cmbLotNumber.Name = "cmbLotNumber";
			this.cmbLotNumber.Size = new System.Drawing.Size(192, 22);
			this.cmbLotNumber.TabIndex = 3;
			this.cmbLotNumber.SelectedIndexChanged += new System.EventHandler(this.cmbLotNumber_SelectedIndexChanged);
			// 
			// lblLotNumber
			// 
			this.lblLotNumber.Location = new System.Drawing.Point(8, 44);
			this.lblLotNumber.Name = "lblLotNumber";
			this.lblLotNumber.Size = new System.Drawing.Size(88, 20);
			this.lblLotNumber.TabIndex = 2;
			this.lblLotNumber.Text = "Lot Number*";
			this.lblLotNumber.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblAntigenTyping
			// 
			this.lblAntigenTyping.Location = new System.Drawing.Point(8, 20);
			this.lblAntigenTyping.Name = "lblAntigenTyping";
			this.lblAntigenTyping.Size = new System.Drawing.Size(88, 20);
			this.lblAntigenTyping.TabIndex = 0;
			this.lblAntigenTyping.Text = "Antigen Typing*";
			this.lblAntigenTyping.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtExpirationDate
			// 
			this.txtExpirationDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtExpirationDate.Location = new System.Drawing.Point(92, 116);
			this.txtExpirationDate.Name = "txtExpirationDate";
			this.txtExpirationDate.ReadOnly = true;
			this.txtExpirationDate.Size = new System.Drawing.Size(192, 20);
			this.txtExpirationDate.TabIndex = 9;
			this.txtExpirationDate.Text = "";
			// 
			// lblExpirationDate
			// 
			this.lblExpirationDate.Location = new System.Drawing.Point(8, 116);
			this.lblExpirationDate.Name = "lblExpirationDate";
			this.lblExpirationDate.Size = new System.Drawing.Size(84, 20);
			this.lblExpirationDate.TabIndex = 8;
			this.lblExpirationDate.Text = "Expires";
			this.lblExpirationDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtManufacturer
			// 
			this.txtManufacturer.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtManufacturer.Location = new System.Drawing.Point(92, 92);
			this.txtManufacturer.Name = "txtManufacturer";
			this.txtManufacturer.ReadOnly = true;
			this.txtManufacturer.Size = new System.Drawing.Size(192, 20);
			this.txtManufacturer.TabIndex = 7;
			this.txtManufacturer.Text = "";
			// 
			// lblManufacturer
			// 
			this.lblManufacturer.Location = new System.Drawing.Point(8, 92);
			this.lblManufacturer.Name = "lblManufacturer";
			this.lblManufacturer.Size = new System.Drawing.Size(88, 20);
			this.lblManufacturer.TabIndex = 6;
			this.lblManufacturer.Text = "Manufacturer";
			this.lblManufacturer.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpTestingPhases
			// 
			this.grpTestingPhases.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.grpTestingPhases.Controls.Add(this.rdo37AHGCC);
			this.grpTestingPhases.Controls.Add(this.rdoIS);
			this.grpTestingPhases.Controls.Add(this.rdoISRT);
			this.grpTestingPhases.Controls.Add(this.rdoIS37);
			this.grpTestingPhases.Controls.Add(this.rdoAHGCC);
			this.grpTestingPhases.Location = new System.Drawing.Point(304, 14);
			this.grpTestingPhases.Name = "grpTestingPhases";
			this.grpTestingPhases.Size = new System.Drawing.Size(156, 122);
			this.grpTestingPhases.TabIndex = 12;
			this.grpTestingPhases.TabStop = false;
			this.grpTestingPhases.Text = "Testing Phases*";
			// 
			// rdo37AHGCC
			// 
			this.rdo37AHGCC.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.rdo37AHGCC.Enabled = false;
			this.rdo37AHGCC.Location = new System.Drawing.Point(8, 96);
			this.rdo37AHGCC.Name = "rdo37AHGCC";
			this.rdo37AHGCC.Size = new System.Drawing.Size(136, 20);
			this.rdo37AHGCC.TabIndex = 4;
			this.rdo37AHGCC.Text = "3&7/AHG/CC";
			this.rdo37AHGCC.CheckedChanged += new System.EventHandler(this.rdo37AHGCC_CheckedChanged);
			// 
			// rdoIS
			// 
			this.rdoIS.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.rdoIS.Enabled = false;
			this.rdoIS.Location = new System.Drawing.Point(8, 16);
			this.rdoIS.Name = "rdoIS";
			this.rdoIS.Size = new System.Drawing.Size(136, 20);
			this.rdoIS.TabIndex = 0;
			this.rdoIS.TabStop = true;
			this.rdoIS.Text = "&IS";
			this.rdoIS.CheckedChanged += new System.EventHandler(this.rdoIS_CheckedChanged);
			// 
			// rdoISRT
			// 
			this.rdoISRT.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.rdoISRT.Enabled = false;
			this.rdoISRT.Location = new System.Drawing.Point(8, 36);
			this.rdoISRT.Name = "rdoISRT";
			this.rdoISRT.Size = new System.Drawing.Size(136, 20);
			this.rdoISRT.TabIndex = 1;
			this.rdoISRT.Text = "IS/&RT";
			this.rdoISRT.CheckedChanged += new System.EventHandler(this.rdoISRT_CheckedChanged);
			// 
			// rdoIS37
			// 
			this.rdoIS37.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.rdoIS37.Enabled = false;
			this.rdoIS37.Location = new System.Drawing.Point(8, 56);
			this.rdoIS37.Name = "rdoIS37";
			this.rdoIS37.Size = new System.Drawing.Size(136, 20);
			this.rdoIS37.TabIndex = 2;
			this.rdoIS37.Text = "IS/&37";
			this.rdoIS37.CheckedChanged += new System.EventHandler(this.rdoIS37_CheckedChanged);
			// 
			// rdoAHGCC
			// 
			this.rdoAHGCC.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.rdoAHGCC.Enabled = false;
			this.rdoAHGCC.Location = new System.Drawing.Point(8, 76);
			this.rdoAHGCC.Name = "rdoAHGCC";
			this.rdoAHGCC.Size = new System.Drawing.Size(136, 20);
			this.rdoAHGCC.TabIndex = 3;
			this.rdoAHGCC.Text = "A&HG/CC";
			this.rdoAHGCC.CheckedChanged += new System.EventHandler(this.rdoAHGCC_CheckedChanged);
			// 
			// lblAntigen
			// 
			this.lblAntigen.Location = new System.Drawing.Point(8, 68);
			this.lblAntigen.Name = "lblAntigen";
			this.lblAntigen.Size = new System.Drawing.Size(80, 20);
			this.lblAntigen.TabIndex = 4;
			this.lblAntigen.Text = "Reagent Type";
			this.lblAntigen.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtAntigen
			// 
			this.txtAntigen.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtAntigen.Location = new System.Drawing.Point(92, 68);
			this.txtAntigen.Name = "txtAntigen";
			this.txtAntigen.ReadOnly = true;
			this.txtAntigen.Size = new System.Drawing.Size(192, 20);
			this.txtAntigen.TabIndex = 5;
			this.txtAntigen.Text = "";
			// 
			// cmbRack
			// 
			this.cmbRack.Enabled = false;
			this.cmbRack.Interval = 500;
			this.cmbRack.Location = new System.Drawing.Point(92, 140);
			this.cmbRack.MaxLength = 2;
			this.cmbRack.Name = "cmbRack";
			this.cmbRack.Size = new System.Drawing.Size(44, 22);
			this.cmbRack.TabIndex = 11;
			this.cmbRack.EnabledChanged += new System.EventHandler(this.cmbRack_EnabledChanged);
			this.cmbRack.SelectedIndexChanged += new System.EventHandler(this.cmbRack_SelectedIndexChanged);
			// 
			// lblRack
			// 
			this.lblRack.Location = new System.Drawing.Point(8, 140);
			this.lblRack.Name = "lblRack";
			this.lblRack.Size = new System.Drawing.Size(88, 20);
			this.lblRack.TabIndex = 10;
			this.lblRack.Text = "Rack*";
			this.lblRack.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(372, 441);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 3;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			this.btnOK.MouseHover += new System.EventHandler(this.btnOK_MouseHover);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(452, 441);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 4;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.MouseHover += new System.EventHandler(this.btnCancel_MouseHover);
			// 
			// lvAntisera
			// 
			this.lvAntisera.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvAntisera.CheckBoxes = true;
			this.lvAntisera.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						 this.columnHeader1,
																						 this.columnHeader2,
																						 this.columnHeader7,
																						 this.columnHeader3,
																						 this.columnHeader14,
																						 this.columnHeader15,
																						 this.columnHeader4,
																						 this.columnHeader5});
			this.lvAntisera.FullRowSelect = true;
			this.lvAntisera.HideSelection = false;
			this.lvAntisera.Location = new System.Drawing.Point(8, 16);
			this.lvAntisera.MultiSelect = false;
			this.lvAntisera.Name = "lvAntisera";
			this.lvAntisera.Size = new System.Drawing.Size(452, 88);
			this.lvAntisera.TabIndex = 0;
			this.lvAntisera.View = System.Windows.Forms.View.Details;
			this.lvAntisera.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvAntisera_ColumnClick);
			this.lvAntisera.SelectedIndexChanged += new System.EventHandler(this.lvAntisera_SelectedIndexChanged);
			this.lvAntisera.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvAntisera_ItemCheck);
			// 
			// columnHeader1
			// 
			this.columnHeader1.Text = "";
			this.columnHeader1.Width = 25;
			// 
			// columnHeader2
			// 
			this.columnHeader2.Text = "Typing";
			this.columnHeader2.Width = 45;
			// 
			// columnHeader7
			// 
			this.columnHeader7.Text = "Reagent";
			// 
			// columnHeader3
			// 
			this.columnHeader3.Text = "Lot Number";
			this.columnHeader3.Width = 80;
			// 
			// columnHeader14
			// 
			this.columnHeader14.Text = "Manufacturer";
			this.columnHeader14.Width = 80;
			// 
			// columnHeader15
			// 
			this.columnHeader15.Text = "Expires";
			this.columnHeader15.Width = 80;
			// 
			// columnHeader4
			// 
			this.columnHeader4.Text = "Phases";
			this.columnHeader4.Width = 50;
			// 
			// columnHeader5
			// 
			this.columnHeader5.Text = "Rack";
			this.columnHeader5.Width = 40;
			// 
			// pnlNewAntisera
			// 
			this.pnlNewAntisera.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlNewAntisera.Controls.Add(this.grpAntisera);
			this.pnlNewAntisera.Controls.Add(this.grpSelectedSpecificities);
			this.pnlNewAntisera.Controls.Add(this.cbPartialWorklist);
			this.pnlNewAntisera.Controls.Add(this.grpAutomatedInstrument);
			this.pnlNewAntisera.Controls.Add(this.grpTestingMethod);
			this.pnlNewAntisera.Location = new System.Drawing.Point(60, 68);
			this.pnlNewAntisera.Name = "pnlNewAntisera";
			this.pnlNewAntisera.Size = new System.Drawing.Size(468, 376);
			this.pnlNewAntisera.TabIndex = 2;
			this.pnlNewAntisera.VisibleChanged += new System.EventHandler(this.pnlNewAntisera_VisibleChanged);
			// 
			// grpSelectedSpecificities
			// 
			this.grpSelectedSpecificities.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpSelectedSpecificities.Controls.Add(this.lvAntisera);
			this.grpSelectedSpecificities.Location = new System.Drawing.Point(0, 248);
			this.grpSelectedSpecificities.Name = "grpSelectedSpecificities";
			this.grpSelectedSpecificities.Size = new System.Drawing.Size(468, 112);
			this.grpSelectedSpecificities.TabIndex = 3;
			this.grpSelectedSpecificities.TabStop = false;
			this.grpSelectedSpecificities.Text = "Selected Specificities";
			// 
			// cbPartialWorklist
			// 
			this.cbPartialWorklist.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.cbPartialWorklist.Location = new System.Drawing.Point(0, 360);
			this.cbPartialWorklist.Name = "cbPartialWorklist";
			this.cbPartialWorklist.Size = new System.Drawing.Size(204, 16);
			this.cbPartialWorklist.TabIndex = 4;
			this.cbPartialWorklist.Text = "Select Partially Completed &Worklist.";
			this.cbPartialWorklist.Visible = false;
			this.cbPartialWorklist.CheckedChanged += new System.EventHandler(this.cbPartialWorklist_CheckedChanged);
			// 
			// grpAutomatedInstrument
			// 
			this.grpAutomatedInstrument.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpAutomatedInstrument.Controls.Add(this.cbAutomatedInstrument);
			this.grpAutomatedInstrument.Controls.Add(this.cbInstrumentQCd);
			this.grpAutomatedInstrument.Controls.Add(this.txtInstrumentName);
			this.grpAutomatedInstrument.Controls.Add(this.lblInstrumentName);
			this.grpAutomatedInstrument.Location = new System.Drawing.Point(176, 0);
			this.grpAutomatedInstrument.Name = "grpAutomatedInstrument";
			this.grpAutomatedInstrument.Size = new System.Drawing.Size(292, 80);
			this.grpAutomatedInstrument.TabIndex = 1;
			this.grpAutomatedInstrument.TabStop = false;
			// 
			// cbAutomatedInstrument
			// 
			this.cbAutomatedInstrument.Location = new System.Drawing.Point(8, 0);
			this.cbAutomatedInstrument.Name = "cbAutomatedInstrument";
			this.cbAutomatedInstrument.Size = new System.Drawing.Size(172, 16);
			this.cbAutomatedInstrument.TabIndex = 0;
			this.cbAutomatedInstrument.Text = "&Using Automated Instrument";
			this.cbAutomatedInstrument.CheckedChanged += new System.EventHandler(this.cbAutomatedInstrument_CheckedChanged);
			// 
			// cbInstrumentQCd
			// 
			this.cbInstrumentQCd.CheckAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.cbInstrumentQCd.Enabled = false;
			this.cbInstrumentQCd.Location = new System.Drawing.Point(8, 44);
			this.cbInstrumentQCd.Name = "cbInstrumentQCd";
			this.cbInstrumentQCd.Size = new System.Drawing.Size(120, 20);
			this.cbInstrumentQCd.TabIndex = 3;
			this.cbInstrumentQCd.Text = "Instrument &QC\'d?";
			this.cbInstrumentQCd.CheckedChanged += new System.EventHandler(this.cbInstrumentQCd_CheckedChanged);
			// 
			// txtInstrumentName
			// 
			this.txtInstrumentName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtInstrumentName.Enabled = false;
			this.txtInstrumentName.Location = new System.Drawing.Point(112, 20);
			this.txtInstrumentName.MaxLength = 50;
			this.txtInstrumentName.Name = "txtInstrumentName";
			this.txtInstrumentName.Size = new System.Drawing.Size(164, 20);
			this.txtInstrumentName.TabIndex = 2;
			this.txtInstrumentName.Text = "";
			this.txtInstrumentName.TextChanged += new System.EventHandler(this.txtInstrumentName_TextChanged);
			// 
			// lblInstrumentName
			// 
			this.lblInstrumentName.Location = new System.Drawing.Point(8, 20);
			this.lblInstrumentName.Name = "lblInstrumentName";
			this.lblInstrumentName.Size = new System.Drawing.Size(100, 20);
			this.lblInstrumentName.TabIndex = 1;
			this.lblInstrumentName.Text = "Instrument Name*";
			this.lblInstrumentName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpTestingMethod
			// 
			this.grpTestingMethod.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpTestingMethod.Controls.Add(this.rdoTube);
			this.grpTestingMethod.Controls.Add(this.rdoGel);
			this.grpTestingMethod.Controls.Add(this.rdoSolidPhase);
			this.grpTestingMethod.Location = new System.Drawing.Point(0, 0);
			this.grpTestingMethod.Name = "grpTestingMethod";
			this.grpTestingMethod.Size = new System.Drawing.Size(172, 80);
			this.grpTestingMethod.TabIndex = 0;
			this.grpTestingMethod.TabStop = false;
			this.grpTestingMethod.Text = "Testing Method*";
			// 
			// rdoTube
			// 
			this.rdoTube.Checked = true;
			this.rdoTube.Location = new System.Drawing.Point(8, 16);
			this.rdoTube.Name = "rdoTube";
			this.rdoTube.Size = new System.Drawing.Size(52, 20);
			this.rdoTube.TabIndex = 0;
			this.rdoTube.TabStop = true;
			this.rdoTube.Text = "&Tube";
			this.rdoTube.CheckedChanged += new System.EventHandler(this.TestingMethodChanged);
			// 
			// rdoGel
			// 
			this.rdoGel.Location = new System.Drawing.Point(8, 36);
			this.rdoGel.Name = "rdoGel";
			this.rdoGel.Size = new System.Drawing.Size(56, 20);
			this.rdoGel.TabIndex = 1;
			this.rdoGel.Text = "&Gel";
			this.rdoGel.CheckedChanged += new System.EventHandler(this.TestingMethodChanged);
			// 
			// rdoSolidPhase
			// 
			this.rdoSolidPhase.Location = new System.Drawing.Point(8, 56);
			this.rdoSolidPhase.Name = "rdoSolidPhase";
			this.rdoSolidPhase.Size = new System.Drawing.Size(92, 20);
			this.rdoSolidPhase.TabIndex = 2;
			this.rdoSolidPhase.Text = "Solid &Phase";
			this.rdoSolidPhase.CheckedChanged += new System.EventHandler(this.TestingMethodChanged);
			// 
			// lblTestedBy
			// 
			this.lblTestedBy.Location = new System.Drawing.Point(220, 12);
			this.lblTestedBy.Name = "lblTestedBy";
			this.lblTestedBy.Size = new System.Drawing.Size(68, 20);
			this.lblTestedBy.TabIndex = 2;
			this.lblTestedBy.Text = "Tested By*";
			this.lblTestedBy.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cmbTestedBy
			// 
			this.cmbTestedBy.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbTestedBy.Interval = 100;
			this.cmbTestedBy.Location = new System.Drawing.Point(284, 12);
			this.cmbTestedBy.MaxLength = 50;
			this.cmbTestedBy.Name = "cmbTestedBy";
			this.cmbTestedBy.Size = new System.Drawing.Size(168, 22);
			this.cmbTestedBy.TabIndex = 3;
			this.cmbTestedBy.SelectedIndexChanged += new System.EventHandler(this.cmbTestedBy_SelectedIndexChanged);
			// 
			// dtpDateTested
			// 
			this.dtpDateTested.CustomFormat = "MM/dd/yyyy HH:mm";
			this.dtpDateTested.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpDateTested.Location = new System.Drawing.Point(80, 12);
			this.dtpDateTested.Name = "dtpDateTested";
			this.dtpDateTested.Size = new System.Drawing.Size(120, 20);
			this.dtpDateTested.TabIndex = 1;
			this.dtpDateTested.ValueChanged += new System.EventHandler(this.dtpDateTested_ValueChanged);
			// 
			// lblDateTested
			// 
			this.lblDateTested.Location = new System.Drawing.Point(8, 12);
			this.lblDateTested.Name = "lblDateTested";
			this.lblDateTested.Size = new System.Drawing.Size(72, 20);
			this.lblDateTested.TabIndex = 0;
			this.lblDateTested.Text = "Date Tested*";
			this.lblDateTested.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// pnlPartialComplete
			// 
			this.pnlPartialComplete.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlPartialComplete.Controls.Add(this.cbNewWorklist);
			this.pnlPartialComplete.Controls.Add(this.grpPartialWorklists);
			this.pnlPartialComplete.Location = new System.Drawing.Point(60, 68);
			this.pnlPartialComplete.Name = "pnlPartialComplete";
			this.pnlPartialComplete.Size = new System.Drawing.Size(468, 376);
			this.pnlPartialComplete.TabIndex = 1;
			this.pnlPartialComplete.Visible = false;
			this.pnlPartialComplete.VisibleChanged += new System.EventHandler(this.pnlPartialComplete_VisibleChanged);
			// 
			// cbNewWorklist
			// 
			this.cbNewWorklist.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.cbNewWorklist.Location = new System.Drawing.Point(0, 360);
			this.cbNewWorklist.Name = "cbNewWorklist";
			this.cbNewWorklist.Size = new System.Drawing.Size(164, 16);
			this.cbNewWorklist.TabIndex = 12;
			this.cbNewWorklist.Text = "Create New &Worklist";
			this.cbNewWorklist.CheckedChanged += new System.EventHandler(this.cbNewWorklist_CheckedChanged);
			// 
			// grpPartialWorklists
			// 
			this.grpPartialWorklists.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpPartialWorklists.Controls.Add(this.tabControl1);
			this.grpPartialWorklists.Controls.Add(this.lvPartialWorklists);
			this.grpPartialWorklists.Controls.Add(this.btnDelete);
			this.grpPartialWorklists.Location = new System.Drawing.Point(0, 0);
			this.grpPartialWorklists.Name = "grpPartialWorklists";
			this.grpPartialWorklists.Size = new System.Drawing.Size(468, 360);
			this.grpPartialWorklists.TabIndex = 0;
			this.grpPartialWorklists.TabStop = false;
			this.grpPartialWorklists.Text = "Select Partially Completed Antigen Typing Worklist(s)";
			// 
			// tabControl1
			// 
			this.tabControl1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.tabControl1.Controls.Add(this.pageSpecificities);
			this.tabControl1.Controls.Add(this.pageUnits);
			this.tabControl1.Location = new System.Drawing.Point(8, 168);
			this.tabControl1.Name = "tabControl1";
			this.tabControl1.SelectedIndex = 0;
			this.tabControl1.Size = new System.Drawing.Size(456, 160);
			this.tabControl1.TabIndex = 1;
			// 
			// pageSpecificities
			// 
			this.pageSpecificities.Controls.Add(this.lvSpecificities);
			this.pageSpecificities.Location = new System.Drawing.Point(4, 23);
			this.pageSpecificities.Name = "pageSpecificities";
			this.pageSpecificities.Size = new System.Drawing.Size(448, 133);
			this.pageSpecificities.TabIndex = 0;
			this.pageSpecificities.Text = "Antiserum Specificities";
			// 
			// lvSpecificities
			// 
			this.lvSpecificities.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvSpecificities.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																							  this.columnHeader6,
																							  this.columnHeader10,
																							  this.columnHeader17,
																							  this.columnHeader21,
																							  this.columnHeader20,
																							  this.columnHeader18,
																							  this.columnHeader19});
			this.lvSpecificities.FullRowSelect = true;
			this.lvSpecificities.Location = new System.Drawing.Point(0, 0);
			this.lvSpecificities.MultiSelect = false;
			this.lvSpecificities.Name = "lvSpecificities";
			this.lvSpecificities.Size = new System.Drawing.Size(448, 136);
			this.lvSpecificities.TabIndex = 0;
			this.lvSpecificities.View = System.Windows.Forms.View.Details;
			this.lvSpecificities.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvSpecificities_ColumnClick);
			// 
			// columnHeader6
			// 
			this.columnHeader6.Text = "Typing";
			this.columnHeader6.Width = 45;
			// 
			// columnHeader10
			// 
			this.columnHeader10.Text = "Reagent";
			this.columnHeader10.Width = 65;
			// 
			// columnHeader17
			// 
			this.columnHeader17.Text = "Lot Number";
			this.columnHeader17.Width = 85;
			// 
			// columnHeader21
			// 
			this.columnHeader21.Text = "Manufacturer";
			this.columnHeader21.Width = 80;
			// 
			// columnHeader20
			// 
			this.columnHeader20.Text = "Expires";
			this.columnHeader20.Width = 85;
			// 
			// columnHeader18
			// 
			this.columnHeader18.Text = "Phases";
			this.columnHeader18.Width = 50;
			// 
			// columnHeader19
			// 
			this.columnHeader19.Text = "Rack";
			this.columnHeader19.Width = 40;
			// 
			// pageUnits
			// 
			this.pageUnits.Controls.Add(this.lvSelectedUnits);
			this.pageUnits.Location = new System.Drawing.Point(4, 23);
			this.pageUnits.Name = "pageUnits";
			this.pageUnits.Size = new System.Drawing.Size(448, 133);
			this.pageUnits.TabIndex = 1;
			this.pageUnits.Text = "Selected Units";
			// 
			// lvSelectedUnits
			// 
			this.lvSelectedUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvSelectedUnits.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																							  this.columnHeader11,
																							  this.columnHeader12,
																							  this.columnHeader13,
																							  this.columnHeader16});
			this.lvSelectedUnits.FullRowSelect = true;
			this.lvSelectedUnits.Location = new System.Drawing.Point(0, 0);
			this.lvSelectedUnits.MultiSelect = false;
			this.lvSelectedUnits.Name = "lvSelectedUnits";
			this.lvSelectedUnits.Size = new System.Drawing.Size(448, 136);
			this.lvSelectedUnits.TabIndex = 72;
			this.lvSelectedUnits.View = System.Windows.Forms.View.Details;
			this.lvSelectedUnits.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvSelectedUnits_ColumnClick);
			// 
			// columnHeader11
			// 
			this.columnHeader11.Text = "Unit ID";
			this.columnHeader11.Width = 100;
			// 
			// columnHeader12
			// 
			this.columnHeader12.Text = "Product";
			this.columnHeader12.Width = 120;
			// 
			// columnHeader13
			// 
			this.columnHeader13.Text = "ABO/Rh";
			this.columnHeader13.Width = 80;
			// 
			// columnHeader16
			// 
			this.columnHeader16.Text = "Expires";
			this.columnHeader16.Width = 120;
			// 
			// lvPartialWorklists
			// 
			this.lvPartialWorklists.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.lvPartialWorklists.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																								 this.columnHeader8,
																								 this.columnHeader9,
																								 this.columnHeader23,
																								 this.columnHeader24});
			this.lvPartialWorklists.FullRowSelect = true;
			this.lvPartialWorklists.HideSelection = false;
			this.lvPartialWorklists.Location = new System.Drawing.Point(8, 16);
			this.lvPartialWorklists.MultiSelect = false;
			this.lvPartialWorklists.Name = "lvPartialWorklists";
			this.lvPartialWorklists.Size = new System.Drawing.Size(452, 148);
			this.lvPartialWorklists.TabIndex = 0;
			this.lvPartialWorklists.View = System.Windows.Forms.View.Details;
			this.lvPartialWorklists.ColumnClick += new System.Windows.Forms.ColumnClickEventHandler(this.lvPartialWorklists_ColumnClick);
			this.lvPartialWorklists.SelectedIndexChanged += new System.EventHandler(this.lvPartialWorklists_SelectedIndexChanged);
			// 
			// columnHeader8
			// 
			this.columnHeader8.Text = "Created By";
			this.columnHeader8.Width = 120;
			// 
			// columnHeader9
			// 
			this.columnHeader9.Text = "Date Tested";
			this.columnHeader9.Width = 100;
			// 
			// columnHeader23
			// 
			this.columnHeader23.Text = "Testing Method";
			this.columnHeader23.Width = 90;
			// 
			// columnHeader24
			// 
			this.columnHeader24.Text = "Automated Instrument";
			this.columnHeader24.Width = 120;
			// 
			// btnDelete
			// 
			this.btnDelete.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnDelete.Enabled = false;
			this.btnDelete.Image = ((System.Drawing.Image)(resources.GetObject("btnDelete.Image")));
			this.btnDelete.ImageAlign = System.Drawing.ContentAlignment.MiddleLeft;
			this.btnDelete.Location = new System.Drawing.Point(356, 332);
			this.btnDelete.Name = "btnDelete";
			this.btnDelete.Size = new System.Drawing.Size(108, 23);
			this.btnDelete.TabIndex = 2;
			this.btnDelete.Text = "&Delete Worklist";
			this.btnDelete.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			this.btnDelete.Click += new System.EventHandler(this.btnDelete_Click);
			this.btnDelete.MouseHover += new System.EventHandler(this.btnDelete_MouseHover);
			// 
			// grpTestingDetails
			// 
			this.grpTestingDetails.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpTestingDetails.Controls.Add(this.lblDateTested);
			this.grpTestingDetails.Controls.Add(this.dtpDateTested);
			this.grpTestingDetails.Controls.Add(this.cmbTestedBy);
			this.grpTestingDetails.Controls.Add(this.lblTestedBy);
			this.grpTestingDetails.Location = new System.Drawing.Point(60, 28);
			this.grpTestingDetails.Name = "grpTestingDetails";
			this.grpTestingDetails.Size = new System.Drawing.Size(468, 40);
			this.grpTestingDetails.TabIndex = 0;
			this.grpTestingDetails.TabStop = false;
			// 
			// DlgSelectSpecificities
			// 
			this.AcceptButton = this.btnAdd;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(532, 473);
			this.Controls.Add(this.pnlNewAntisera);
			this.Controls.Add(this.grpTestingDetails);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.pnlPartialComplete);
			this.hlphelpChm.SetHelpKeyword(this, "Unit_Antigen_Typing.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(540, 500);
			this.Name = "DlgSelectSpecificities";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Unit Antigen Typing";
			this.Load += new System.EventHandler(this.DlgSelectSpecificities_Load);
			this.Controls.SetChildIndex(this.pnlPartialComplete, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.grpTestingDetails, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.pnlNewAntisera, 0);
			this.grpImage.ResumeLayout(false);
			this.grpAntisera.ResumeLayout(false);
			this.grpTestingPhases.ResumeLayout(false);
			this.pnlNewAntisera.ResumeLayout(false);
			this.grpSelectedSpecificities.ResumeLayout(false);
			this.grpAutomatedInstrument.ResumeLayout(false);
			this.grpTestingMethod.ResumeLayout(false);
			this.pnlPartialComplete.ResumeLayout(false);
			this.grpPartialWorklists.ResumeLayout(false);
			this.tabControl1.ResumeLayout(false);
			this.pageSpecificities.ResumeLayout(false);
			this.pageUnits.ResumeLayout(false);
			this.grpTestingDetails.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Initialize user control properties
		/// </summary>
		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC041.DlgSelectSpecificities_New());
			//
			//set current date value based on the division time zone
			_currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			this.dtpDateTested.Value = _currentDate;
			this.dtpDateTested.MaxDate = _currentDate;
			//
			this.btnOK.Text = "&OK";
			this.btnOK.EnabledButton = false;
			//
			this.btnAdd.Text = "&Add";
			this.btnAdd.EnabledButton = false;
			//
			this.cmbAntigenTyping.Interval = 100;
			this.cmbLotNumber.Interval = 100;
			this.cmbRack.Interval = 100;
			//
			this.cmbAntigenTyping.SelectedIndex = -1;
			this.cmbAntigenTyping.Enabled = true;
			//
			this.cmbLotNumber.SelectedIndex = -1;
			//
			this.rdoAHGCC.Checked = false;
			this.rdoIS.Checked = false;
			this.rdoIS37.Checked = false;
			this.rdoISRT.Checked = false;
			this.rdo37AHGCC.Checked = false;
			this.rdo37AHGCC.Enabled = false;
			//Setting both of these to unchecked will result in 
			//the radio buttons losing their tabstop value
			//don't ask me why, ask microsoft.
			this.rdoIS.TabStop = true;
			//
			//this.rdoTube.Checked = false;
			//this.rdoGel.Checked = false;
			//this.rdoSolidPhase.Checked = false;
			//
			this.cbAutomatedInstrument.Checked = false;
			//
			//set custom date and time format
			this.dtpDateTested.CustomFormat = Common.VBECSDateTime.DateTimeFormat;

		}

		private void InitializeWorklist()
		{
			this._antiseraWorklist = new BOL.AntiseraWorklist(Guid.NewGuid());
			AttachAntiseraWorklistEvents();
			//
			this.dtpDateTested.Value  = _currentDate;
			this.dtpDateTested_ValueChanged(this,EventArgs.Empty);
			//
			this.LoadUserList();
			this.cmbTestedBy_SelectedIndexChanged(this,EventArgs.Empty);
			//
			this.cbAutomatedInstrument.Checked = false;
			this.txtInstrumentName.Text = "";
			this.cbInstrumentQCd.Checked = false;
			this.cbAutomatedInstrument_CheckedChanged(this,EventArgs.Empty);
			//
			this.rdoTube.Checked = true;
			this.rdoGel.Checked = false;
			this.rdoSolidPhase.Checked = false;
			//
			this.TestingMethodChanged(this,EventArgs.Empty);
			//

		}

		private void AttachAntiseraWorklistEvents()
		{
			if (this.pnlNewAntisera.Visible)
			{
				this._antiseraWorklist.SetInitialBrokenRules(this.Name,"AntiseraWorklist");
			}
			else
			{
				this._antiseraWorklist.SetInitialBrokenRules(this.Name,"PartialAntiseraWorklist");
			}
			//
			this._antiseraWorklist.Valid += new System.EventHandler(CheckWorklistValid);
			this._antiseraWorklist.Invalid += new System.EventHandler(CheckWorklistValid);
		}

		/// <summary>
		/// Attach valid and invalid object event handlers to Rack Lot object
		/// </summary>
		private void AttachEvents()
		{
			//
			this._rackLot.Valid += new System.EventHandler(CheckValid);
			this._rackLot.Invalid += new System.EventHandler(CheckValid);
			if (this._rackLot.Rack != null)
			{
				this._rackLot.Rack.Valid += new System.EventHandler(CheckValid);
				this._rackLot.Rack.Invalid += new System.EventHandler(CheckValid);
			}
			if (this._rackLot.Reagent != null)
			{
				this._rackLot.Reagent.Valid += new System.EventHandler(CheckValid);
				this._rackLot.Reagent.Invalid += new System.EventHandler(CheckValid);
				//
				if (this._rackLot.Reagent.ReagentType != null)
				{
					this._rackLot.Reagent.ReagentType.Valid += new System.EventHandler(CheckValid);
					this._rackLot.Reagent.ReagentType.Invalid += new System.EventHandler(CheckValid);
				}
			}
		}

		/// <summary>
		/// Valid and invalid event handler, enables Add button
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void CheckValid(object sender, System.EventArgs e)
		{
			//this.IsDirty = true;
			//
			this.btnAdd.EnabledButton = 
				(this._rackLot.IsValid && 
				this._rackLot.Reagent.IsValid &&
				this._rackLot.Reagent.ReagentType.IsValid &&
				this._rackLot.Rack.IsValid &&
				this.errError.GetError(cmbRack).Length==0);
		}

		private void CheckWorklistValid(object sender, System.EventArgs e)
		{
			//this.IsDirty = true;
			//
			if (this.pnlNewAntisera.Visible)
			{
				this.btnOK.EnabledButton = (this._antiseraWorklist.IsValid && this.lvAntisera.CheckedItems.Count>0);
			}
			else
			{
				this.btnOK.EnabledButton = (this._antiseraWorklist.IsValid && this.lvPartialWorklists.SelectedItems.Count>0);
			}
		}

		/// <summary>
		/// Load the list of antigen typing tests
		/// </summary>
		private void LoadAntigenTypingTests()
		{
			this._dtTests = BOL.AntigenTyping.GetAntigenTypingTests();
			//Need to set this, because by default it is false, and Select comparisons will be case-insensitive
			this._dtTests.CaseSensitive = true;
			foreach(DataRow drTest in _dtTests.Rows)
			{
				cmbAntigenTyping.Items.Add(drTest[Common.VbecsTables.OrderableTest.OrderableTestName].ToString());
			}
		}

		/// <summary>
		/// Load the list of racks
		/// </summary>
		private void LoadRackList()
		{
			this.cmbRack.Items.Clear();

			_dtRacks = BOL.Rack.GetDailyQCRacks(this.dtpDateTested.Value);
			DataTable dtAvailableRacks = _dtRacks.Clone();
			foreach(DataRow drRack in _dtRacks.Rows)
			{
				//CR 3069 Added check for DailyUseInicator to filter out racks that are marked "Not In Use Today"
				if (drRack.IsNull(Common.VbecsTables.DailyQcWorklist.DailyUseIndicator) == false)
				{
					if( !(bool)drRack[Common.VbecsTables.DailyQcWorklist.DailyUseIndicator] )
						continue;
				}
				
				cmbRack.Items.Add(drRack[Common.VbecsTables.Rack.RackName]);
				dtAvailableRacks.Rows.Add(drRack.ItemArray);
			}

			this._dtRacks = dtAvailableRacks;
		}

		/// <summary>
		/// Load the reagents lots based on reagent type
		/// Implements BR_41.04
		/// </summary>
		/// <param name="reagentTypeID">Reagent Type ID</param>
		private void LoadReagentsByType(int reagentTypeID)
		{
			cmbLotNumber.Items.Clear();
			//
			_dtReagents = BOL.Reagent.GetReagentsByType(LogonUser.LogonUserDivisionCode,reagentTypeID);
			//
			foreach(DataRow drReagent in _dtReagents.Rows)
			{
				cmbLotNumber.Items.Add(drReagent[Common.VbecsTables.Reagent.LotNumber]);
			}
		}

		/// <summary>
		/// Load the partially completed antisera worklists
		/// </summary>
		private void LoadPartiallyCompletedAntiseraWorklists()
		{
			_antiseraWorklists = BOL.AntiseraWorklist.GetPartiallyCompletedWorklists();
			//
			if (_antiseraWorklists.Rows.Count>0)
			{
				foreach(DataRow drWorklist in _antiseraWorklists.Rows)
				{
					ListViewItem lvi = new ListViewItem(drWorklist[Common.VbecsTables.AntiseraWorklist.WorklistName].ToString());
					lvi.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(drWorklist[Common.VbecsTables.AntiseraWorklist.WorklistCreateDate]));
					lvi.SubItems.Add(drWorklist[Common.VbecsTables.TestingMethod.TestingMethodText].ToString());
					if (drWorklist[Common.VbecsTables.AntiseraWorklist.AutoInstrumentName].ToString().Length>0)
					{
						lvi.SubItems.Add(drWorklist[Common.VbecsTables.AntiseraWorklist.AutoInstrumentName].ToString());
					}
					lvi.Tag = drWorklist;
					this.lvPartialWorklists.Items.Add(lvi);
				}
				//
				controls.VbecsFunction.SetColumnWidths(lvPartialWorklists);
				//
				this.pnlPartialComplete.Visible = true;
				this.pnlNewAntisera.Visible = false;
				this.cbPartialWorklist.Visible = true;
				//
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC041.DlgSelectSpecificities_Worksheet());
			}
			else
			{
				this.pnlPartialComplete.Visible = false;
				this.pnlNewAntisera.Visible = true;
				this._antiseraWorklist = new BOL.AntiseraWorklist(Guid.NewGuid());
				//
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC041.DlgSelectSpecificities_New());
			}
			//
		}

		/// <summary>
		/// Load the antisera specificities associated with an antisera worklist
		/// </summary>
		/// <param name="antiseraWorklistGUID">Antisera worklist unique identifier</param>
		private void LoadSpecificities(Guid antiseraWorklistGUID)
		{
			this.lvSpecificities.Items.Clear();
			//
			this._dtSpecificities = BOL.AntiseraWorklist.GetAntiseraWorklistDetails(antiseraWorklistGUID);
			//
			if (this._dtSpecificities.Rows.Count>0)
			{
				foreach(DataRow drRackLot in this._dtSpecificities.Rows)
				{
					ListViewItem lvi = new ListViewItem(drRackLot[Common.VbecsTables.OrderableTest.OrderableTestName].ToString());
					lvi.Tag = drRackLot;
					lvi.SubItems.Add(drRackLot[Common.VbecsTables.ReagentType.ReagentTypeName].ToString());
					lvi.SubItems.Add(drRackLot[Common.VbecsTables.Reagent.LotNumber].ToString());
					lvi.SubItems.Add(drRackLot[Common.VbecsTables.Reagent.ReagentManufacturerName].ToString());
					lvi.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(drRackLot[Common.VbecsTables.Reagent.LotExpirationDate]));
					lvi.SubItems.Add(drRackLot[Common.VbecsTables.ReactivityPhase.ReactivityPhaseText].ToString());
					lvi.SubItems.Add(drRackLot[Common.VbecsTables.Rack.RackName].ToString());
					this.lvSpecificities.Items.Add(lvi);
				}
				//
				controls.VbecsFunction.SetColumnWidths(this.lvSpecificities);
			}
		}

		/// <summary>
		/// Load the blood units associated with an antisera worklist
		/// </summary>
		/// <param name="antiseraWorklistGUID">Antisera worklist unique identifier</param>
		private void LoadBloodUnits(Guid antiseraWorklistGUID)
		{
			this.lvSelectedUnits.Items.Clear();
			//
			this._dtUnits = BOL.AntiseraWorklist.GetAntiseraWorklistUnits(antiseraWorklistGUID);
			//
			if (this._dtUnits.Rows.Count>0)
			{
				foreach(DataRow drUnit in this._dtUnits.Rows)
				{
					ListViewItem lvi = new ListViewItem(drUnit[Common.VbecsTables.BloodUnit.EyeReadableUnitId].ToString());
					lvi.Tag = drUnit;
					lvi.SubItems.Add(drUnit[Common.VbecsTables.BloodProduct.ProductShortName].ToString()+", "+
						BOL.BloodUnit.GetFullProductCode((Common.BarcodeType)Convert.ToChar(drUnit[Common.VbecsTables.BloodUnit.LabelTypeCode]),drUnit[Common.VbecsTables.BloodUnit.UnitProductCode].ToString(),Convert.ToChar(drUnit[Common.VbecsTables.DonationType.DonationTypeCode]),drUnit[Common.VbecsTables.BloodUnit.UnitDivisionId].ToString()));
					lvi.SubItems.Add(drUnit["AboRh"].ToString());
					lvi.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(drUnit[Common.VbecsTables.BloodUnitMedia.UnitExpirationDate]));
					this.lvSelectedUnits.Items.Add(lvi);
				}
				//
				controls.VbecsFunction.SetColumnWidths(this.lvSelectedUnits);
			}
		}

		/// <summary>
		/// cmbAntigenTyping selected index changed event handler
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void cmbAntigenTyping_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (cmbAntigenTyping.SelectedIndex>-1)
			{
				_drAntigenTyping = _dtTests.Rows[cmbAntigenTyping.SelectedIndex];
				//
				foreach(ListViewItem lvi in this.lvAntisera.Items)
				{
					if (lvi.SubItems[1].Text == _drAntigenTyping[Common.VbecsTables.OrderableTest.OrderableTestText].ToString())
					{
						lvi.Selected = true;
						lvAntisera_SelectedIndexChanged(sender,e);
						return;
					}
				}
				//
				cmbLotNumber.SelectedIndex = -1;
				_rackLot.Reagent = new BOL.Reagent();
				_rackLot.Reagent.SetInitialBrokenRules(this.Name,"Reagent");
				_rackLot.Reagent.ReagentType = new BOL.ReagentType(this._drAntigenTyping);
				//
				LoadReagentsByType((int)this._drAntigenTyping[Common.VbecsTables.ReagentType.ReagentTypeId]);
				//
				if (Convert.ToInt32(this._drAntigenTyping[Common.VbecsTables.OrderableTest.OrderableTestId]) == (int)Common.OrderableTest.AGwD)
				{
					//DR 3613 - user will always have to specify lot number for Anti-D 
					this.cmbLotNumber.Enabled = true;
					this.rdoIS.Enabled = false;
					this.rdoISRT.Enabled = false;
					this.rdoIS37.Enabled = false;
					this.rdoAHGCC.Enabled = false;
					this.rdo37AHGCC.Enabled = true;
					ResetTestingPhases();
					this.rdo37AHGCC.Checked = true;
					this.rdo37AHGCC_CheckedChanged(sender,e);
					//this.TestingPhaseCheckChanged(sender,e);
				}
				else
				{
					this.cmbLotNumber.Enabled = true;
					this.rdoIS.Enabled = true;
					this.rdoISRT.Enabled = true;
					this.rdoIS37.Enabled = true;
					this.rdoAHGCC.Enabled = true;
					this.rdo37AHGCC.Enabled = false;
					ResetTestingPhases();
				}
			}
			else
			{
				//
				cmbLotNumber.SelectedIndex = -1;
				cmbLotNumber.Items.Clear();
				cmbLotNumber.Enabled = false;
				//
			}
			//
			AttachEvents();
			//
			CheckValid(sender,e);
		}

		/// <summary>
		/// cmbLotNumber selected index changed event handler
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void cmbLotNumber_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (cmbLotNumber.SelectedIndex > -1)
			{
				_rackLot.Reagent = new BOL.Reagent(_dtReagents.Rows[cmbLotNumber.SelectedIndex]);
				_rackLot.Reagent.ReagentType = new BOL.ReagentType(this._drAntigenTyping);

				//DR 3613 do not check testing phases for Weak D
				if (Convert.ToInt32(this._drAntigenTyping[Common.VbecsTables.OrderableTest.OrderableTestId]) != (int)Common.OrderableTest.AGwD)
				{
					if (!this.IsTestingPhaseCorrect())
					{
						//uncheck all testing phases
						ResetTestingPhases();
					}
				}
			}
			else
			{
				_rackLot.Reagent = new BOL.Reagent();
				_rackLot.Reagent.ReagentType = new BOL.ReagentType();
			}
			//
			AttachEvents();
			_rackLot.Reagent.SetInitialBrokenRules(this.Name,"Reagent");
			_rackLot.Reagent.LotNumber = _rackLot.Reagent.LotNumber;
			//
			txtAntigen.Text = _rackLot.Reagent.ReagentType.ReagentTypeName;
			txtManufacturer.Text = _rackLot.Reagent.ReagentManufacturerName;
			if (_rackLot.Reagent.LotExpirationDate == DateTime.MinValue)
			{
				txtExpirationDate.Text = string.Empty;
			}
			else
			{
				txtExpirationDate.Text = _rackLot.Reagent.LotExpirationDate.ToString(Common.VBECSDateTime.DateTimeFormat);
			}
			//
			CheckValid(sender,e);
		}

		/// <summary>
		/// cmbRack selected index changed event handler
		/// Implements BR_41.30
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void cmbRack_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			bool qcOffline = false;

			if (cmbRack.SelectedIndex>-1)
			{
				DataRow dr = _dtRacks.Rows[cmbRack.SelectedIndex];
				//
				//CR 2718 - skip check for BR_41.30 if QC was done Offline
				if (dr.IsNull(Common.VbecsTables.DailyQcWorklist.QCOfflineIndicator) == false)
				{
					if ((bool)dr[Common.VbecsTables.DailyQcWorklist.QCOfflineIndicator] == true)
						qcOffline = true;
				}

				//DR 3613 - user will have to select lot number for Anti-D reagent
				if (qcOffline == false)
				{
					//BR_41.30
					DataTable dt = BOL.Reagent.GetReagentFromRack((Guid)dr[Common.VbecsTables.Rack.RackGuid],(int)Common.ReagentType.AntiA,Common.LogonUser.LogonUserDivisionCode);
					if (dt.Rows.Count == 0)
					{
						cmbLotNumber.SelectedIndex = -1;
						cmbLotNumber_SelectedIndexChanged(sender,e);
						errError.SetVbecsError(cmbRack, Common.StrRes.Tooltips.Common.RackNotConfigured().ResString); // **** 508 Compliance ***
						return;
					}
				}
				//
				_rackLot.Rack = new BOL.Rack(dr);
				errError.SetVbecsError(cmbRack, string.Empty); // **** 508 Compliance ***
				//
			}
			else
			{
				_rackLot.Rack = new BOL.Rack();
				AttachEvents();
				_rackLot.Rack.SetInitialBrokenRules(this.Name,"Rack");
				errError.SetVbecsError(cmbRack, string.Empty); // **** 508 Compliance ***
			}
			//
			AttachEvents();
			//
			CheckValid(sender,e);
		}

		/// <summary>
		/// btnClear click event handler
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnClear_Click(object sender, System.EventArgs e)
		{
			ClearTyping();
			//Weird -- Broken Rules only reset if called twice!!
			ClearTyping();
		}

		private void ClearTyping()
		{
			this._drAntigenTyping = null;
			_rackLot = new BOL.RackLot();
			_rackLot.RackLotGuid = Guid.NewGuid();
			_rackLot.Rack = new BOL.Rack();
			_rackLot.Reagent = new BOL.Reagent();
			_rackLot.Reagent.ReagentType = new BOL.ReagentType();
			this.AttachEvents();
			_rackLot.SetInitialBrokenRules(this.Name,"RackLot");
			_rackLot.Reagent.SetInitialBrokenRules(this.Name,"Reagent");
			_rackLot.Reagent.ReagentType.SetInitialBrokenRules(this.Name,"ReagentType");
			//
			this.cmbRack.SelectedIndex = -1;
			this.cmbLotNumber.SelectedIndex = -1;
			this.cmbAntigenTyping.SelectedIndex = -1;
			//
			this.rdoIS.Enabled = false;
			this.rdoISRT.Enabled = false;
			this.rdoIS37.Enabled = false;
			this.rdoAHGCC.Enabled = false;
			this.rdo37AHGCC.Enabled = false;
			//
			this.rdoAHGCC.Checked = false;
			this.rdoIS.Checked = false;
			this.rdoIS37.Checked = false;
			this.rdoISRT.Checked = false;
			this.rdo37AHGCC.Checked = false;
			//Setting both of these to unchecked will result in 
			//the radio buttons losing their tabstop value
			//don't ask me why, ask microsoft.
			this.rdoIS.TabStop = true;
			//
			this.cmbAntigenTyping.Focus();
		}

		/// <summary>
		/// Update details of specificity in list view
		/// </summary>
		/// <param name="lvi">List view item</param>
		private void UpdateSpecificity(ListViewItem lvi)
		{
			lvi.Tag = _rackLot;
			lvi.Checked = true;
			lvi.SubItems[3].Text = _rackLot.Reagent.LotNumber;
			lvi.SubItems[4].Text = _rackLot.Reagent.ReagentManufacturerName;
			lvi.SubItems[5].Text = _rackLot.Reagent.LotExpirationDate.ToString(Common.VBECSDateTime.DateTimeFormat);
			lvi.SubItems[6].Text = _rackLot.ReactivityPhaseText;
			lvi.SubItems[7].Text = _rackLot.Rack.RackName;
			CheckItemsInList();
			controls.VbecsFunction.SetColumnWidths(this.lvAntisera);
		}

		/// <summary>
		/// Add new specificity to list view
		/// </summary>
		private void AddSpecificity()
		{
			ListViewItem lviAdd = new ListViewItem();
			lviAdd.Tag = _rackLot;
			lviAdd.Checked = true;
			lviAdd.SubItems.Add(_drAntigenTyping[Common.VbecsTables.OrderableTest.OrderableTestName].ToString());
			lviAdd.SubItems.Add(_rackLot.Reagent.ReagentType.ReagentTypeName);
			lviAdd.SubItems.Add(_rackLot.Reagent.LotNumber);
			lviAdd.SubItems.Add(_rackLot.Reagent.ReagentManufacturerName);
			lviAdd.SubItems.Add(_rackLot.Reagent.LotExpirationDate.ToString(Common.VBECSDateTime.DateTimeFormat));
			lviAdd.SubItems.Add(_rackLot.ReactivityPhaseText);
			lviAdd.SubItems.Add(_rackLot.Rack.RackName);
			this.lvAntisera.Items.Add(lviAdd);
			CheckItemsInList();
			controls.VbecsFunction.SetColumnWidths(this.lvAntisera);
		}

		/// <summary>
		/// btnAdd click event handler. Add or update selected specificity.
		/// Implements BR_56.07, BR_41.04
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnAdd_Click(object sender, System.EventArgs e)
		{
			this._rackLot.Rack.Comments = "";
			//
			if (this.cmbRack.SelectedIndex>-1)
			{
				//BR_56.07
				if (!this._rackLot.Rack.IsRackQCd(this.dtpDateTested.Value))
				{
					DlgOverrideComment dlg = new DlgOverrideComment("QC not performed", "Rack QC not performed. Continue to use?", "PT");
					if (dlg.ShowDialog(this) == DialogResult.Cancel)
					{
						this.cmbRack.SelectedIndex = -1;
						this.cmbRack_SelectedIndexChanged(sender,e);
						return;
					}
					this._rackLot.Rack.Comments = dlg.Comment;
				}
			}
			//
			this._rackLot.Comments = "";
			//BR_41.04
			if (this._rackLot.Reagent.LotExpirationDate < _currentDate)
			{
				DlgOverrideComment dlg = new DlgOverrideComment("Expired Antiserum",Common.StrRes.Tooltips.UC041.ExpiredAntiserum(this._rackLot.Reagent.ReagentType.ReagentTypeName).ResString,"UT");
				if (dlg.ShowDialog(this)!=DialogResult.OK)
				{
					this.cmbLotNumber.SelectedIndex = -1;
					return;
				}
				this._rackLot.Comments = dlg.Comment;
			}
			//
			if (Convert.ToInt32(this._drAntigenTyping[Common.VbecsTables.OrderableTest.OrderableTestId]) == (int)Common.OrderableTest.AGwD)
			{
				//DR 3613 - user will always have to specify lot number for Anti-D Control
				DlgSelectDControl dlgDControl = new DlgSelectDControl();
				if (dlgDControl.ShowDialog(this) != DialogResult.OK)
				{
					return;
				}
				this._antiDControlGuid = dlgDControl.AntiDControlGuid;
				//
				BOL.Reagent antiDControl = new BOL.Reagent(this._antiDControlGuid);
				if (antiDControl.LotExpirationDate < _currentDate)
				{
					DlgOverrideComment dlg = new DlgOverrideComment("Expired Antiserum",Common.StrRes.Tooltips.UC041.ExpiredAntiserum(antiDControl.ReagentType.ReagentTypeName).ResString,"UT");
					if (dlg.ShowDialog(this)!=DialogResult.OK)
					{
						return;
					}
					this._antiDControlComment = dlg.Comment;
				}
				else
				{
					this._antiDControlComment = null;
				}
			}
			//
			foreach(ListViewItem lvi in this.lvAntisera.Items)
			{
				if (lvi.SubItems[2].Text == _rackLot.Reagent.ReagentType.ReagentTypeName)
				{
					UpdateSpecificity(lvi);
					//
					this.btnClear_Click(sender,e);
					//Weird - broken rules only work if I add this second clear call!!!
					this.btnClear_Click(sender,e);
					//
					return;
				}
			}
			//
			AddSpecificity();
			//
			this.btnClear_Click(sender,e);
		}

		/// <summary>
		/// btnAdd mouse hover event handler, displays tool tip
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnAdd_MouseHover(object sender, System.EventArgs e)
		{
			if (this.btnAdd.EnabledButton)
			{
				btnAdd.SetToolTip(Common.StrRes.Tooltips.UC041.AddUpdateAntiseraSpecificity().ResString);
			}
			else
			{
				btnAdd.SetToolTip(Common.Utility.SumBrokenRulesMessages(
					this._rackLot.Reagent.ReagentType.GetBrokenRulesMessage(this.Name),
					this._rackLot.Reagent.GetBrokenRulesMessage(this.Name),
					this._rackLot.GetBrokenRulesMessage(this.Name),
					this._rackLot.Rack.GetBrokenRulesMessage(this.Name),
					this.errError.GetError(cmbRack)));
			}
		}

		/// <summary>
		/// btnOK mouse hover event handler, displays tool tip
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnOK_MouseHover(object sender, System.EventArgs e)
		{
			if (this.btnOK.EnabledButton)
			{
				btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToContinue().ResString);
			}
			else
			{
				string tooltip = "";
				if (!this._antiseraWorklist.IsValid)
				{
					tooltip = this._antiseraWorklist.GetBrokenRulesMessage(this.Name);
				}
				//
				if (this.pnlNewAntisera.Visible)
				{
					if (this.lvAntisera.CheckedItems.Count == 0)
					{
						tooltip = tooltip + "\n" + Common.StrRes.Tooltips.UC041.DefineAntiseraSpecificity().ResString;
					}
				}
				else
				{
					if (this.lvPartialWorklists.SelectedItems.Count == 0)
					{
						tooltip = tooltip + "\n" + Common.StrRes.Tooltips.UC041.SelectAntigenTypingWorklist().ResString;
					}
				}
				//
				btnOK.SetToolTip(tooltip);
			}
		}

		/// <summary>
		/// cmbRack enabled changed event handler
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void cmbRack_EnabledChanged(object sender, System.EventArgs e)
		{
			if (!cmbRack.Enabled)
			{
				cmbRack.SelectedIndex = -1;
			}
		}

		/// <summary>
		/// Check if specificities have been defined, enable OK button
		/// </summary>
		private void CheckItemsInList()
		{
			btnOK.EnabledButton = ((this.lvAntisera.CheckedItems.Count>0) && (this._antiseraWorklist.IsValid));
		}

		/// <summary>
		/// lvAntisera item check event handler, enable OK button
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void lvAntisera_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			if ((e.NewValue == CheckState.Unchecked) && (lvAntisera.CheckedItems.Count<2))
			{
				this.btnOK.EnabledButton = false;
			}
			else
			{
				this.btnOK.EnabledButton = (this._antiseraWorklist.IsValid);
			}
		}

		/// <summary>
		/// lvAntisera column click event handler, sorts items based on column
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Column click event args</param>
		private void lvAntisera_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			if (e.Column == 4)
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvAntisera.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.DateTime);
			}
			else
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender, e, lvAntisera.CheckBoxes, controls.ColumnClickSorter.ColumnSortType.String);
			}
		}

		/// <summary>
		/// lvAntisera selected index changed event handler, displays selected specificity for editing
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void lvAntisera_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (this.lvAntisera.SelectedItems.Count>0)
			{
				BOL.RackLot rackLot = (BOL.RackLot)this.lvAntisera.SelectedItems[0].Tag;
				//
				string test = this.lvAntisera.SelectedItems[0].SubItems[1].Text;
				this.cmbAntigenTyping.SelectedIndex = this.cmbAntigenTyping.Items.IndexOf(test);
				this.cmbAntigenTyping_SelectedIndexChanged(sender,e);
				//
				this.cmbLotNumber.SelectedIndex = this.cmbLotNumber.Items.IndexOf(rackLot.Reagent.LotNumber);
				this.cmbLotNumber_SelectedIndexChanged(sender,e);
				//
				if (rackLot.ReactivityPhaseCode == ((int)Common.ReactivityPhase.ThreeSevenandAHG).ToString())
				{
					this.rdo37AHGCC.Checked = true;
					this.cmbRack.SelectedIndex = this.cmbRack.Items.IndexOf(rackLot.Rack.RackName);
				}
				else if (rackLot.ReactivityPhaseCode == ((int)Common.ReactivityPhase.AHGandCC).ToString())
				{
					this.rdoAHGCC.Checked = true;
					this.cmbRack.SelectedIndex = this.cmbRack.Items.IndexOf(rackLot.Rack.RackName);
				}
				else if (rackLot.ReactivityPhaseCode == ((int)Common.ReactivityPhase.IS).ToString())
				{
					this.rdoIS.Checked = true;
				}
				else if (rackLot.ReactivityPhaseCode == ((int)Common.ReactivityPhase.ISandRT).ToString())
				{
					this.rdoISRT.Checked = true;
				}
				else if (rackLot.ReactivityPhaseCode == ((int)Common.ReactivityPhase.ISand37).ToString())
				{
					this.rdoIS37.Checked = true;
				}
				this.cmbRack_SelectedIndexChanged(sender,e);
			}
			this.lvAntisera.SelectedItems.Clear();
		}

		/// <summary>
		/// Create antisera worklist typing table based on defined specificities
		/// </summary>
		private void CreateAntiseraTypingTable()
		{
			_antiseraWorklistTypings = new System.Data.DataTable();
			_antiseraWorklistTypings.Columns.Add("AntiseraWorklistTypingGuid", typeof(Guid));
			_antiseraWorklistTypings.Columns.Add(Common.VbecsTables.AntiseraWorklist.AntiseraWorklistGuid, typeof(Guid));
			_antiseraWorklistTypings.Columns.Add(Common.VbecsTables.OrderableTest.OrderableTestId,typeof(string));
			_antiseraWorklistTypings.Columns.Add(Common.VbecsTables.RackLot.ReagentGuid, typeof(Guid));
			_antiseraWorklistTypings.Columns.Add(Common.VbecsTables.RackLot.RackGuid,typeof(Guid));
			_antiseraWorklistTypings.Columns.Add(Common.VbecsTables.RackLot.ReactivityPhaseCode,typeof(string));
			_antiseraWorklistTypings.Columns.Add(Common.VbecsTables.RackLot.Comments,typeof(string));
			_antiseraWorklistTypings.Columns.Add(Common.VbecsTables.RackLot.DivisionCode,typeof(string));
			_antiseraWorklistTypings.Columns.Add(Common.VbecsTables.RackLot.TestWithId,typeof(int));
			_antiseraWorklistTypings.Columns.Add("RackQCOverrideComment",typeof(string));
			_antiseraWorklistTypings.Columns.Add("ExpiredOverrideComment",typeof(string));
			_antiseraWorklistTypings.Columns.Add("PhaseOverrideComment",typeof(string));
			//_antiseraWorklistTypings.Columns.Add(Common.VbecsTables.RackLot.LastUpdateUser,typeof(string));
			//
			foreach(ListViewItem lvi in this.lvAntisera.CheckedItems)
			{
				BOL.RackLot rackLot = (BOL.RackLot)lvi.Tag;
				//
				DataRow dr = _antiseraWorklistTypings.NewRow();
				dr["AntiseraWorklistTypingGuid"] = Guid.NewGuid();
				dr[Common.VbecsTables.AntiseraWorklist.AntiseraWorklistGuid] = this._antiseraWorklist.AntiseraWorklistGuid;
				if (rackLot.Rack.RackGuid != Guid.Empty)
				{
					dr[Common.VbecsTables.RackLot.RackGuid] = rackLot.Rack.RackGuid;
					//
					if (rackLot.Rack.Comments.Trim().Length>0)
					{
						dr["RackQCOverrideComment"] = rackLot.Rack.Comments;
					}
				}
				dr[Common.VbecsTables.RackLot.ReagentGuid] = rackLot.Reagent.ReagentGuid;
				dr[Common.VbecsTables.RackLot.DivisionCode] = LogonUser.LogonUserDivisionCode;
				//dr[Common.VbecsTables.RackLot.LastUpdateUser] = Common.LogonUser.LogonUserName;
				dr[Common.VbecsTables.RackLot.ReactivityPhaseCode] = rackLot.ReactivityPhaseCode;
				//
				if (rackLot.Comments.Trim().Length>0)
				{
					dr["ExpiredOverrideComment"] = rackLot.Comments;
				}
				//
				if (rackLot.Reagent.Comments.Trim().Length>0)
				{
					dr["PhaseOverrideComment"] = rackLot.Reagent.Comments;
				}
				//
				DataRow[] tests = this._dtTests.Select(Common.VbecsTables.OrderableTest.OrderableTestName+" = '"+lvi.SubItems[1].Text+"'");
				dr[Common.VbecsTables.OrderableTest.OrderableTestId] = tests[0][Common.VbecsTables.OrderableTest.OrderableTestId];
				//
				_antiseraWorklistTypings.Rows.Add(dr);
			}
			//
		}

		/// <summary>
		/// btnOK click event handler, closes form and opens FrmRecordPhenotypeResults
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			if (IsCurrentUserAuthorizedForFunction(Common.FunctionCode.StandardAccess))
			{
				FrmRecordPhenotypeResults frm;

				if (pnlNewAntisera.Visible)
				{
					CreateAntiseraTypingTable();
					frm = new FrmRecordPhenotypeResults(this._antiseraWorklist,this._antiseraWorklistTypings,this._antiDControlGuid,this._antiDControlComment);
				}
				else
				{
					frm = new FrmRecordPhenotypeResults(this._antiseraWorklist,this._dtSpecificities,this._dtUnits);
				}

				if (frm.DialogResult == DialogResult.Abort)		//Lock failure will set to Abort
				{
					frm.Dispose();
					return;
				}

				frm.MdiParent = this.Owner;
				frm.Show();         //this form doesn't lock, so leaving with Show(); (locking is isolated within btnDelete)
				//this.IsDirty = false;
				this.Close();
			}
			else
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges("perform this function"));
			}
		}

		/// <summary>
		/// cbNewWorklist checkbox changed event handler, hides partial worklist
		/// selection panel and displays new worklist definition panel
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void cbNewWorklist_CheckedChanged(object sender, System.EventArgs e)
		{
			if (cbNewWorklist.Checked)
			{
				this.cbNewWorklist.Checked = false;
				this.pnlPartialComplete.Visible = false;
				this.pnlNewAntisera.Visible = true;
				//
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC041.DlgSelectSpecificities_New());
				//
				this.InitializeWorklist();
				this.CheckWorklistValid(sender,e);
			}
		}

		/// <summary>
		/// cbPartialWorklist checkbox changed event handler, hides new worklist
		/// definition panel and displays partial worklist selection panel
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void cbPartialWorklist_CheckedChanged(object sender, System.EventArgs e)
		{
			if (cbPartialWorklist.Checked)
			{
				this.cbPartialWorklist.Checked = false;
				this.pnlPartialComplete.Visible = true;
				this.pnlNewAntisera.Visible = false;
				//
				this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC041.DlgSelectSpecificities_Worksheet());
				//
				this.InitializeWorklist();
				this.CheckWorklistValid(sender,e);
			}
		}

		/// <summary>
		/// lvPartialWorklists selected index changed event handler. Display
		/// specificities and units associated with selected worklist and enable OK button
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void lvPartialWorklists_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (this.lvPartialWorklists.SelectedItems.Count>0)
			{
				DataRow drWorklist = (DataRow)this.lvPartialWorklists.SelectedItems[0].Tag;
				this._antiseraWorklist = new BOL.AntiseraWorklist((Guid)drWorklist[Common.VbecsTables.AntiseraWorklist.AntiseraWorklistGuid]);
				this.AttachAntiseraWorklistEvents();
				this._antiseraWorklist.WorklistCreateDate = this.dtpDateTested.Value;
				this._antiseraWorklist.WorklistName = ( this.cmbTestedBy.SelectedIndex > -1 ) ? (string)this.cmbTestedBy.SelectedItem : String.Empty;
				//
				this.LoadSpecificities(this._antiseraWorklist.AntiseraWorklistGuid);
				this.LoadBloodUnits(this._antiseraWorklist.AntiseraWorklistGuid);
			}
			else
			{
				this.lvSpecificities.Items.Clear();
				this.lvSelectedUnits.Items.Clear();
			}
			//
			this.CheckWorklistValid(sender,e);
			this.btnDelete.Enabled = (this.lvPartialWorklists.SelectedItems.Count>0);
		}

		/// <summary>
		/// btnDelete click event handler. Inactivated selected worklist.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnDelete_Click(object sender, System.EventArgs e)
		{
			System.Data.DataTable dtLocks = BOL.AntiseraWorklist.GetAntiseraWorklistDetails(this._antiseraWorklist.AntiseraWorklistGuid);
            foreach (System.Data.DataRow drTest in dtLocks.Rows)
            {
                this.LockController.RecordGuids.Add((System.Guid)drTest[ANTISERAWORKLISTTYPING.AntiseraWorklistTypingGuid]);
            }

			//Attempt to lock the UnitTests to be invalidated
			if (!this.SetLocks()) return;

			DlgOverrideComment dlgOverride = new DlgOverrideComment("Invalidate Results",Common.StrRes.ConfMsg.UC041.DeleteAntiseraWorklist().ResString,"UT");

            dlgOverride.ShowDialogFromLockedParent(this, false);
            if (dlgOverride.DialogResult == DialogResult.OK)
            {
                if (!this._antiseraWorklist.InvalidateAntiseraWorklist(_dtSpecificities, _dtUnits, Common.UpdateFunction.UC041FrmRecordPhenotypeResults, dlgOverride.Comment, true))
                {
                    this.ReleaseLocks();
                    GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataNotInvalidated("antisera worklist"));
                    return;
                }
            }
			
			this.ReleaseLocks();
            if (dlgOverride.DialogResult != DialogResult.OK) return;    //trying to streamline this method a bit
			this.lvPartialWorklists.Items.RemoveAt(this.lvPartialWorklists.SelectedItems[0].Index);
			this.lvPartialWorklists.SelectedItems.Clear();
			this.btnOK.EnabledButton = false;
			this.btnDelete.Enabled = false;
		}

		/// <summary>
		/// Load the list of users into cmbTestedBy
		/// </summary>
		private void LoadUserList()
		{
			cmbTestedBy.SelectedIndex = -1;
			cmbTestedBy.Items.Clear();
			
			foreach( BOL.VbecsUser _user in BOL.VbecsUser.GetActiveDivisionUsers( LogonUser.LogonUserDivisionCode ) )
				this.cmbTestedBy.Items.Add( _user.UserName );

			this.cmbTestedBy.SelectedItem = ThisUser.UserName;
		}

		/// <summary>
		/// DlgSelectSpecificities form load event handler. Loads selection data.
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void DlgSelectSpecificities_Load(object sender, System.EventArgs e)
		{
			btnClear_Click(null,EventArgs.Empty);
			//
			LoadAntigenTypingTests();
			LoadRackList();
			LoadPartiallyCompletedAntiseraWorklists();
			//
			//Weird - broken rules only work if I add this second clear call!!!
			btnClear_Click(null,EventArgs.Empty);
			this.IsDirty = false;
		}

		/// <summary>
		/// dtpDateTested value changed event handler. Check non-future date
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void dtpDateTested_ValueChanged(object sender, System.EventArgs e)
		{
			if(!this._isLoading)
			{
				if (this.dtpDateTested.Value > _currentDate)
				{
					this.errError.SetVbecsError(this.dtpDateTested, Common.StrRes.SysErrMsg.Common.DateSetToFuture("Date Tested").ResString); // **** 508 Compliance ***
					this._antiseraWorklist.WorklistCreateDate = DateTime.MinValue;
				}
				else
				{
					this.errError.SetVbecsError(this.dtpDateTested, string.Empty); // **** 508 Compliance ***
					this._antiseraWorklist.WorklistCreateDate = this.dtpDateTested.Value;
				}
				//
				this.LoadRackList();
				CheckWorklistValid(sender,e);
			}
		}

		/// <summary>
		/// btnClear mouse hover event handler, displays tool tip
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnClear_MouseHover(object sender, System.EventArgs e)
		{
			this.ttToolTip.SetToolTip(btnClear,Common.StrRes.Tooltips.Common.ClearEntries().ResString);
		}

		/// <summary>
		/// btnCancel mouse hover event handler, displays tool tip
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnCancel_MouseHover(object sender, System.EventArgs e)
		{
			this.ttToolTip.SetToolTip(btnCancel,Common.StrRes.Tooltips.Common.ClickToDisregardChangesAndReturn().ResString);
		}

		/// <summary>
		/// btnDelete mouse hover event handler, displays tool tip
		/// </summary>
		/// <param name="sender">Sender object</param>
		/// <param name="e">Event args</param>
		private void btnDelete_MouseHover(object sender, System.EventArgs e)
		{
			this.ttToolTip.SetToolTip(btnDelete,Common.StrRes.Tooltips.UC041.ClickToDeleteWorklist().ResString);
		}


		private void cbAutomatedInstrument_CheckedChanged(object sender, System.EventArgs e)
		{
			this._antiseraWorklist.AutomatedInstrument = (cbAutomatedInstrument.Checked);
			this.txtInstrumentName.Enabled = (cbAutomatedInstrument.Checked);
			this.cbInstrumentQCd.Enabled = (cbAutomatedInstrument.Checked);
			//
			this.CheckWorklistValid(sender,e);
		}

		private void txtInstrumentName_TextChanged(object sender, System.EventArgs e)
		{
			//if (this.cbInstrumentQCd.Checked)
			//{
				this._antiseraWorklist.AutoInstrumentName = this.txtInstrumentName.Text;
			//}
			//else
			//{
			//	this._antiseraWorklist.AutoInstrumentName = string.Empty;
			//}
			//
			this.CheckWorklistValid(sender,e);
		}

		private void cbInstrumentQCd_CheckedChanged(object sender, System.EventArgs e)
		{
			//if (this.cbInstrumentQCd.Checked)
			//{
				this._antiseraWorklist.AutoInstrumentName = this.txtInstrumentName.Text;
			//}
			//else
			//{
			//	this._antiseraWorklist.AutoInstrumentName = string.Empty;
			//}
			//
			this.CheckWorklistValid(sender,e);
		}

		private void TestingMethodChanged(object sender, System.EventArgs e)
		{
			if (this.rdoTube.Checked)
			{
				this._antiseraWorklist.TestingMethodCode = Common.TestingMethod.Tube;
			}
			else if (rdoGel.Checked)
			{
				this._antiseraWorklist.TestingMethodCode = Common.TestingMethod.Gel;
			}
			else if (rdoSolidPhase.Checked)
			{
				this._antiseraWorklist.TestingMethodCode = Common.TestingMethod.Solid;
			}
			else
			{
				this._antiseraWorklist.TestingMethodCode = Common.TestingMethod.Unknown;
			}
			//
			CheckWorklistValid(sender,e);
		}

		private void cmbTestedBy_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this._antiseraWorklist.WorklistName = ( this.cmbTestedBy.SelectedIndex > -1 ) ? (string)this.cmbTestedBy.SelectedItem : String.Empty;

			CheckWorklistValid(sender,e);
		}

		private void pnlNewAntisera_VisibleChanged(object sender, System.EventArgs e)
		{
			if (this.pnlNewAntisera.Visible)
			{
				this.lvPartialWorklists.SelectedItems.Clear();
				this.InitializeWorklist();
				this.CheckWorklistValid(sender,e);
				//this.IsDirty = false;
			}
		}

		private void rdoIS_CheckedChanged(object sender, System.EventArgs e)
		{
			//
			if (this.rdoIS.Checked)
			{
				_rackLot.ReactivityPhaseCode = ((int)Common.ReactivityPhase.IS).ToString();
				_rackLot.ReactivityPhaseText = BOL.ReferenceData.GetReactivityPhase(Convert.ToInt32(_rackLot.ReactivityPhaseCode))[Common.VbecsTables.ReactivityPhase.ReactivityPhaseText].ToString();//Common.Utility.GetReactivityPhaseTextFromCode(_rackLot.ReactivityPhaseCode);
				//
				this.rdoIS.Checked = IsTestingPhaseCorrect();
			}
			else
			{
				if (_rackLot.ReactivityPhaseCode == ((int)Common.ReactivityPhase.IS).ToString())
				{
					_rackLot.ReactivityPhaseCode = ((int)Common.ReactivityPhase.Unknown).ToString();
					_rackLot.ReactivityPhaseText = "";
				}
			}
			AttachEvents();
			_rackLot.Rack.SetInitialBrokenRules(this.Name,"NoRack");
			_rackLot.Reagent.LotNumber = _rackLot.Reagent.LotNumber;
			lblRack.Enabled = false;
			cmbRack.Enabled = false;
			//
			CheckValid(sender,e);
		}

		private void rdoISRT_CheckedChanged(object sender, System.EventArgs e)
		{
			//
			if (rdoISRT.Checked)
			{
				_rackLot.ReactivityPhaseCode = ((int)Common.ReactivityPhase.ISandRT).ToString();
				_rackLot.ReactivityPhaseText = BOL.ReferenceData.GetReactivityPhase(Convert.ToInt32(_rackLot.ReactivityPhaseCode))[Common.VbecsTables.ReactivityPhase.ReactivityPhaseText].ToString();//Common.Utility.GetReactivityPhaseTextFromCode(_rackLot.ReactivityPhaseCode);
				//
				this.rdoISRT.Checked = IsTestingPhaseCorrect();
			}
			else
			{
				if (_rackLot.ReactivityPhaseCode == ((int)Common.ReactivityPhase.ISandRT).ToString())
				{
					_rackLot.ReactivityPhaseCode = ((int)Common.ReactivityPhase.Unknown).ToString();
					_rackLot.ReactivityPhaseText = "";
				}
			}
			AttachEvents();
			_rackLot.Rack.SetInitialBrokenRules(this.Name,"NoRack");
			_rackLot.Reagent.LotNumber = _rackLot.Reagent.LotNumber;
			lblRack.Enabled = false;
			cmbRack.Enabled = false;
			//
			CheckValid(sender,e);
		}

		private void rdoIS37_CheckedChanged(object sender, System.EventArgs e)
		{
			//
			if (rdoIS37.Checked)
			{
				_rackLot.ReactivityPhaseCode = ((int)Common.ReactivityPhase.ISand37).ToString();
				_rackLot.ReactivityPhaseText = BOL.ReferenceData.GetReactivityPhase(Convert.ToInt32(_rackLot.ReactivityPhaseCode))[Common.VbecsTables.ReactivityPhase.ReactivityPhaseText].ToString();//Common.Utility.GetReactivityPhaseTextFromCode(_rackLot.ReactivityPhaseCode);
				//
				this.rdoIS37.Checked = IsTestingPhaseCorrect();
			}
			else
			{
				if (_rackLot.ReactivityPhaseCode == ((int)Common.ReactivityPhase.ISand37).ToString())
				{
					_rackLot.ReactivityPhaseCode = ((int)Common.ReactivityPhase.Unknown).ToString();
					_rackLot.ReactivityPhaseText = "";
				}
			}
			AttachEvents();
			_rackLot.Rack.SetInitialBrokenRules(this.Name,"NoRack");
			_rackLot.Reagent.LotNumber = _rackLot.Reagent.LotNumber;
			lblRack.Enabled = false;
			cmbRack.Enabled = false;
			//
			CheckValid(sender,e);
		}

		private void rdoAHGCC_CheckedChanged(object sender, System.EventArgs e)
		{
			if (rdoAHGCC.Checked)
			{
				_rackLot.ReactivityPhaseCode = ((int)Common.ReactivityPhase.AHGandCC).ToString();
				_rackLot.ReactivityPhaseText = BOL.ReferenceData.GetReactivityPhase(Convert.ToInt32(_rackLot.ReactivityPhaseCode))[Common.VbecsTables.ReactivityPhase.ReactivityPhaseText].ToString();//Common.Utility.GetReactivityPhaseTextFromCode(_rackLot.ReactivityPhaseCode);
				//
				this.rdoAHGCC.Checked = IsTestingPhaseCorrect();
			}
			else
			{
				if (_rackLot.ReactivityPhaseCode == ((int)Common.ReactivityPhase.AHGandCC).ToString())
				{
					_rackLot.ReactivityPhaseCode = ((int)Common.ReactivityPhase.Unknown).ToString();
					_rackLot.ReactivityPhaseText = "";
				}
			}
			
			AttachEvents();
			_rackLot.Rack.SetInitialBrokenRules(this.Name,"Rack");
			_rackLot.Reagent.LotNumber = _rackLot.Reagent.LotNumber;
			lblRack.Enabled = ((rdo37AHGCC.Checked)||(rdoAHGCC.Checked));
			cmbRack.Enabled = ((rdo37AHGCC.Checked)||(rdoAHGCC.Checked));
			//
			CheckValid(sender,e);
			//

		}

		private void rdo37AHGCC_CheckedChanged(object sender, System.EventArgs e)
		{
			if (rdo37AHGCC.Checked)
			{
				_rackLot.ReactivityPhaseCode = ((int)Common.ReactivityPhase.ThreeSevenandAHG).ToString();
				_rackLot.ReactivityPhaseText = BOL.ReferenceData.GetReactivityPhase(Convert.ToInt32(_rackLot.ReactivityPhaseCode))[Common.VbecsTables.ReactivityPhase.ReactivityPhaseText].ToString();//Common.Utility.GetReactivityPhaseTextFromCode(_rackLot.ReactivityPhaseCode);
				//
				this.rdo37AHGCC.Checked = IsTestingPhaseCorrect();
			}
			else
			{
				if (_rackLot.ReactivityPhaseCode == ((int)Common.ReactivityPhase.ThreeSevenandAHG).ToString())
				{
					_rackLot.ReactivityPhaseCode = ((int)Common.ReactivityPhase.Unknown).ToString();
					_rackLot.ReactivityPhaseText = "";
				}
			}
			
			AttachEvents();
			_rackLot.Rack.SetInitialBrokenRules(this.Name,"Rack");
			_rackLot.Reagent.LotNumber = _rackLot.Reagent.LotNumber;
			lblRack.Enabled = ((rdo37AHGCC.Checked)||(rdoAHGCC.Checked));
			cmbRack.Enabled = ((rdo37AHGCC.Checked)||(rdoAHGCC.Checked));
			//
			CheckValid(sender,e);
		}

		/// <summary>
		/// BR_41.26
		/// </summary>
		/// <returns></returns>
		private bool IsTestingPhaseCorrect()
		{
			this._rackLot.Reagent.Comments = "";
			//
			bool validSelection = this._rackLot.IsReagentTestingPhaseCorrect();
			if (!validSelection)
			{
				DlgOverrideComment dlg = new DlgOverrideComment("Confirm Testing Phases",Common.StrRes.ConfMsg.UC041.IncorrectPhase().ResString,"RS");
				if (dlg.ShowDialog(this)==DialogResult.OK)
				{
					this._rackLot.Reagent.Comments = dlg.Comment;
				}
				else
				{
					return false;
				}
			}
			return true;
		}

		private void ResetTestingPhases()
		{
			if (rdoIS.Checked)
			{
				rdoIS.Checked = false;
			}
			if (rdoISRT.Checked)
			{
				rdoISRT.Checked = false;
			}
			if (rdoIS37.Checked)
			{
				rdoIS37.Checked = false;
			}
			if (rdoAHGCC.Checked)
			{
				rdoAHGCC.Checked = false;
			}
			if (rdo37AHGCC.Checked)
			{
				rdo37AHGCC.Checked = false;
			}
			//
			//Setting all of these to unchecked will result in 
			//the radio buttons losing their tabstop value
			//don't ask me why, ask microsoft.
			this.rdoIS.TabStop = true;
		}

		private void pnlPartialComplete_VisibleChanged(object sender, System.EventArgs e)
		{
			if (this.pnlPartialComplete.Visible)
			{
				this.InitializeWorklist();
				this.CheckWorklistValid(sender,e);
				//this.IsDirty = false;
			}
		}

		private void lvPartialWorklists_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
//			if (e.Column == 2)
//			{
//				controls.ColumnClickSorter.ColumnClickHandler(sender,e,lvPartialWorklists.CheckBoxes,controls.ColumnClickSorter.ColumnSortType.DateTime);
//			}
//			else
//			{
//				controls.ColumnClickSorter.ColumnClickHandler(sender,e,lvPartialWorklists.CheckBoxes,controls.ColumnClickSorter.ColumnSortType.String);
//			}
		}

		private void lvSpecificities_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			if (e.Column == 4)
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender,e,lvSpecificities.CheckBoxes,controls.ColumnClickSorter.ColumnSortType.DateTime);
			}
			else
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender,e,lvSpecificities.CheckBoxes,controls.ColumnClickSorter.ColumnSortType.String);
			}
		}

		private void lvSelectedUnits_ColumnClick(object sender, System.Windows.Forms.ColumnClickEventArgs e)
		{
			if (e.Column == 3)
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender,e,lvSelectedUnits.CheckBoxes,controls.ColumnClickSorter.ColumnSortType.DateTime);
			}
			else
			{
				controls.ColumnClickSorter.ColumnClickHandler(sender,e,lvSelectedUnits.CheckBoxes,controls.ColumnClickSorter.ColumnSortType.String);
			}
		}
	}
}

